@extends('adminlte::page')

@section('title', 'Detalles del Cliente')

@section('content_header')
    <div class="d-flex justify-content-between">
        <h1>Expediente: {{ $cliente->full_name }}</h1>
        <a href="{{ route('home') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Volver</a>
    </div>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <h3 class="profile-username text-center">{{ $cliente->full_name }}</h3>
                    <ul class="list-group list-group-unbordered mb-3">
                        <li class="list-group-item">
                            <b>Teléfono</b> <a class="float-right">{{ $cliente->phone_number ?? 'N/A' }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>Fecha de Registro</b> <a class="float-right">{{ $cliente->created_at->format('d/m/Y') }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            @foreach($cliente->vehicles as $vehiculo)
                <div class="card card-info">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-car"></i> Vehículo: {{ $vehiculo->plate }} ({{ $vehiculo->type }})
                        </h3>
                    </div>
                    <div class="card-body p-0">
                        @if($vehiculo->fines->count() > 0)
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Folio / Concepto</th>
                                        <th>Autoridad</th>
                                        <th>Año</th>
                                        <th>Monto</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($vehiculo->fines as $multa)
                                        <tr>
                                            <td><strong>{{ $multa->folio }}</strong></td>
                                            <td>{{ $multa->authority }}</td>
                                            <td>{{ $multa->fiscal_year }}</td>
                                            <td class="text-danger"><strong>${{ number_format($multa->base_amount, 2) }}</strong></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @else
                            <div class="p-3 text-center text-muted">
                                No se encontraron multas para este vehículo.
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@stop