@extends('adminlte::page')

@section('title', 'ChaoMultas | Panel')

@section('content_header')
    <h1>Nuevas Impugnaciones Recibidas</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body p-0">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Cliente</th>
                                <th>Vehículo</th>
                                <th>Multas Detectadas</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($clientes as $cliente)
                                <tr>
                                    <td>{{ $cliente->created_at->format('d/m/Y H:i') }}</td>
                                    <td>
                                        <strong>{{ $cliente->full_name }}</strong><br>
                                        <small><i class="fas fa-phone"></i> {{ $cliente->phone_number ?? 'Sin teléfono' }}</small>
                                    </td>
                                    <td>
                                        @foreach($cliente->vehicles as $vehiculo)
                                            <span class="badge badge-info">{{ $vehiculo->plate }}</span>
                                            <small class="text-muted">({{ $vehiculo->type }})</small><br>
                                        @endforeach
                                    </td>
                                    <td>
                                        @php $totalMultas = 0; @endphp
                                        @foreach($cliente->vehicles as $vehiculo)
                                            @php $totalMultas += $vehiculo->fines->count(); @endphp
                                        @endforeach
                                        <span class="badge badge-warning">{{ $totalMultas }} Adeudos</span>
                                    </td>
                                    <td>
                                        <a href="{{ route('cliente.show', $cliente->id) }}" class="btn btn-sm btn-primary">Ver Detalles</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">Aún no hay clientes registrados.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop