@extends('adminlte::page')

@section('title', 'Nuevo Usuario')

@section('content_header')
    <h1>Agregar Nuevo Miembro</h1>
@stop

@section('content')
    <div class="card card-primary">
        <form action="{{ route('users.store') }}" method="POST">
            @csrf
            <div class="card-body">
                <div class="form-group">
                    <label>Nombre Completo</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Correo Electrónico (Para iniciar sesión)</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Contraseña Temporal</label>
                    <input type="password" name="password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Asignar Rol</label>
                    <select name="role" class="form-control" required>
                        <option value="">Selecciona un rol...</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Guardar Usuario</button>
                <a href="{{ route('users.index') }}" class="btn btn-default float-right">Cancelar</a>
            </div>
        </form>
    </div>
@stop